/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogUtils.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String f_164908_ = "icon.png";
    private static final ImmutableList<String> f_78193_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String f_202311_ = "Data";
    final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;

    public LevelStorageSource(Path p_78199_, Path p_78200_, DataFixer p_78201_) {
        this.f_78196_ = p_78201_;
        try {
            Files.createDirectories(Files.exists(p_78199_, new LinkOption[0]) ? p_78199_.toRealPath(new LinkOption[0]) : p_78199_, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.f_78194_ = p_78199_;
        this.f_78195_ = p_78200_;
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), DataFixers.m_14512_());
    }

    private static <T> Pair<WorldGenSettings, Lifecycle> m_78204_(Dynamic<T> p_78205_, DataFixer p_78206_, int p_78207_) {
        Dynamic dynamic = p_78205_.get("WorldGenSettings").orElseEmptyMap();
        for (String s : f_78193_) {
            Optional optional = p_78205_.get(s).result();
            if (!optional.isPresent()) continue;
            dynamic = dynamic.set(s, (Dynamic)optional.get());
        }
        Dynamic dynamic1 = p_78206_.update(References.f_16795_, dynamic, p_78207_, SharedConstants.m_183709_().getWorldVersion());
        DataResult dataresult = WorldGenSettings.f_64600_.parse(dynamic1);
        return Pair.of((Object)dataresult.resultOrPartial(Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0))).orElseGet(() -> {
            RegistryAccess registryaccess = RegistryAccess.m_206154_(dynamic1);
            return WorldGenSettings.m_190050_(registryaccess);
        }), (Object)dataresult.lifecycle());
    }

    private static DataPackConfig m_78202_(Dynamic<?> p_78203_) {
        return DataPackConfig.f_45843_.parse(p_78203_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(DataPackConfig.f_45842_);
    }

    public String m_164909_() {
        return "Anvil";
    }

    public List<LevelSummary> m_78244_() throws LevelStorageException {
        File[] afile;
        if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
            throw new LevelStorageException(new TranslatableComponent("selectWorld.load_folder_access").getString());
        }
        ArrayList list = Lists.newArrayList();
        for (File file1 : afile = this.f_78194_.toFile().listFiles()) {
            boolean flag;
            if (!file1.isDirectory()) continue;
            try {
                flag = DirectoryLock.m_13642_((Path)file1.toPath());
            }
            catch (Exception exception) {
                f_78191_.warn("Failed to read {} lock", (Object)file1, (Object)exception);
                continue;
            }
            try {
                LevelSummary levelsummary = this.m_78229_(file1, this.m_78232_(file1, flag));
                if (levelsummary == null) continue;
                list.add(levelsummary);
            }
            catch (OutOfMemoryError outofmemoryerror) {
                MemoryReserve.m_182328_();
                System.gc();
                f_78191_.error(LogUtils.FATAL_MARKER, "Ran out of memory trying to read summary of {}", (Object)file1);
                throw outofmemoryerror;
            }
            catch (StackOverflowError stackoverflowerror) {
                f_78191_.error(LogUtils.FATAL_MARKER, "Ran out of stack trying to read summary of {}. Assuming corruption; attempting to restore from from level.dat_old.", (Object)file1);
                File file2 = new File(file1, "level.dat");
                File file3 = new File(file1, "level.dat_old");
                File file4 = new File(file1, "level.dat_corrupted_" + LocalDateTime.now().format(f_78192_));
                Util.m_212224_(file2, file3, file4, true);
                throw stackoverflowerror;
            }
        }
        return list;
    }

    private int m_78265_() {
        return 19133;
    }

    @Nullable
    <T> T m_78229_(File p_78230_, BiFunction<File, DataFixer, T> p_78231_) {
        T t;
        if (!p_78230_.exists()) {
            return null;
        }
        File file1 = new File(p_78230_, "level.dat");
        if (file1.exists() && (t = p_78231_.apply(file1, this.f_78196_)) != null) {
            return t;
        }
        file1 = new File(p_78230_, "level.dat_old");
        return file1.exists() ? (T)p_78231_.apply(file1, this.f_78196_) : null;
    }

    @Nullable
    private static DataPackConfig m_78252_(File p_78253_, DataFixer p_78254_) {
        try {
            Tag tag = LevelStorageSource.m_202312_(p_78253_);
            if (tag instanceof CompoundTag) {
                CompoundTag compoundtag = (CompoundTag)tag;
                CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                int i = compoundtag1.m_128425_("DataVersion", 99) ? compoundtag1.m_128451_("DataVersion") : -1;
                Dynamic dynamic = p_78254_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundtag1), i, SharedConstants.m_183709_().getWorldVersion());
                return dynamic.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
            }
        }
        catch (Exception exception) {
            f_78191_.error("Exception reading {}", (Object)p_78253_, (Object)exception);
        }
        return null;
    }

    static BiFunction<File, DataFixer, PrimaryLevelData> m_211737_(DynamicOps<Tag> p_211738_, DataPackConfig p_211739_, Lifecycle p_211740_) {
        return (p_211745_, p_211746_) -> {
            try {
                CompoundTag compoundtag = NbtIo.m_128937_(p_211745_);
                CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                CompoundTag compoundtag2 = compoundtag1.m_128425_("Player", 10) ? compoundtag1.m_128469_("Player") : null;
                compoundtag1.m_128473_("Player");
                int i = compoundtag1.m_128425_("DataVersion", 99) ? compoundtag1.m_128451_("DataVersion") : -1;
                Dynamic dynamic = p_211746_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic(p_211738_, (Object)compoundtag1), i, SharedConstants.m_183709_().getWorldVersion());
                Pair<WorldGenSettings, Lifecycle> pair = LevelStorageSource.m_78204_(dynamic, p_211746_, i);
                LevelVersion levelversion = LevelVersion.m_78390_((Dynamic)dynamic);
                LevelSettings levelsettings = LevelSettings.m_46924_(dynamic, p_211739_);
                Lifecycle lifecycle = ((Lifecycle)pair.getSecond()).add(p_211740_);
                PrimaryLevelData worldDataServer = PrimaryLevelData.m_78530_((Dynamic<Tag>)dynamic, p_211746_, i, compoundtag2, levelsettings, levelversion, (WorldGenSettings)pair.getFirst(), lifecycle);
                worldDataServer.pdc = compoundtag1.m_128423_("BukkitValues");
                return worldDataServer;
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", p_211745_, (Object)exception);
                return null;
            }
        };
    }

    BiFunction<File, DataFixer, LevelSummary> m_78232_(File p_78233_, boolean p_78234_) {
        return (p_193015_, p_193016_) -> {
            try {
                Tag tag = LevelStorageSource.m_202312_(p_193015_);
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundtag = (CompoundTag)tag;
                    CompoundTag compoundtag1 = compoundtag.m_128469_(f_202311_);
                    int i = compoundtag1.m_128425_("DataVersion", 99) ? compoundtag1.m_128451_("DataVersion") : -1;
                    Dynamic dynamic = p_193016_.update(DataFixTypes.LEVEL.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundtag1), i, SharedConstants.m_183709_().getWorldVersion());
                    LevelVersion levelversion = LevelVersion.m_78390_((Dynamic)dynamic);
                    int j = levelversion.m_78389_();
                    if (j == 19132 || j == 19133) {
                        boolean flag = j != this.m_78265_();
                        File file1 = new File(p_78233_, f_164908_);
                        DataPackConfig datapackconfig = dynamic.get("DataPacks").result().map(LevelStorageSource::m_78202_).orElse(DataPackConfig.f_45842_);
                        LevelSettings levelsettings = LevelSettings.m_46924_(dynamic, datapackconfig);
                        return new LevelSummary(levelsettings, levelversion, p_78233_.getName(), flag, p_78234_, file1);
                    }
                } else {
                    f_78191_.warn("Invalid root tag in {}", p_193015_);
                }
                return null;
            }
            catch (Exception exception) {
                f_78191_.error("Exception reading {}", p_193015_, (Object)exception);
                return null;
            }
        };
    }

    @Nullable
    private static Tag m_202312_(File p_202313_) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector[]{new FieldSelector(f_202311_, CompoundTag.f_128326_, "Player"), new FieldSelector(f_202311_, CompoundTag.f_128326_, "WorldGenSettings")});
        NbtIo.m_202487_(p_202313_, (StreamTagVisitor)skipfields);
        return skipfields.m_197713_();
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path path = this.f_78194_.resolve(p_78241_);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        return Files.isDirectory(this.f_78194_.resolve(p_78256_), new LinkOption[0]);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        return this.createAccess(p_78261_, null);
    }

    public LevelStorageAccess createAccess(String name, @Nullable ResourceKey<LevelStem> actualDimension) throws IOException {
        return new LevelStorageAccess(name, actualDimension);
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        public final Path f_78271_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();
        @Nullable
        public final ResourceKey<LevelStem> dimensionType;

        public LevelStorageAccess(@Nullable String s, ResourceKey<LevelStem> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.f_78272_ = s;
            this.f_78271_ = LevelStorageSource.this.f_78194_.resolve(s);
            this.f_78270_ = DirectoryLock.m_13640_((Path)this.f_78271_);
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, p_78303_ -> this.f_78271_.resolve(p_78303_.m_78187_()));
        }

        public Path m_197394_(ResourceKey<Level> p_197395_) {
            return DimensionType.m_196975_(p_197395_, (Path)this.f_78271_);
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        @Nullable
        public LevelSummary m_78308_() {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource.this.m_78232_(this.f_78271_.toFile(), false));
        }

        @Nullable
        public WorldData m_211747_(DynamicOps<Tag> p_211748_, DataPackConfig p_211749_, Lifecycle p_211750_) {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource.m_211737_(p_211748_, p_211749_, p_211750_));
        }

        public void readAdditionalLevelSaveData() {
            this.m_78313_();
            LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), (file, dataFixer) -> {
                try {
                    CompoundTag compoundTag = NbtIo.m_128937_(file);
                    ForgeHooks.readAdditionalLevelSaveData((CompoundTag)compoundTag, (Path)this.f_78271_);
                }
                catch (Exception e) {
                    f_78191_.error("Exception reading {}", file, (Object)e);
                }
                return "";
            });
        }

        @Nullable
        public DataPackConfig m_78309_() {
            this.m_78313_();
            return LevelStorageSource.this.m_78229_(this.f_78271_.toFile(), LevelStorageSource::m_78252_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            File file1 = this.f_78271_.toFile();
            CompoundTag compoundtag = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_(LevelStorageSource.f_202311_, compoundtag);
            ForgeHooks.writeAdditionalLevelSaveData((WorldData)p_78292_, (CompoundTag)compoundtag1);
            try {
                File file2 = File.createTempFile("level", ".dat", file1);
                NbtIo.m_128944_(compoundtag1, file2);
                File file3 = new File(file1, "level.dat_old");
                File file4 = new File(file1, "level.dat");
                Util.m_137462_(file4, file2, file3);
            }
            catch (Exception exception) {
                f_78191_.error("Failed to save level {}", (Object)file1, (Object)exception);
            }
        }

        public Optional<Path> m_182514_() {
            return !this.f_78270_.m_13639_() ? Optional.empty() : Optional.of(this.f_78271_.resolve(LevelStorageSource.f_164908_));
        }

        public Path getWorldDir() {
            return this.f_78271_;
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path path = this.f_78271_.resolve("session.lock");
            f_78191_.info("Deleting level {}", (Object)this.f_78272_);
            for (int i = 1; i <= 5; ++i) {
                f_78191_.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.f_78271_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals(path)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_78271_)) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i >= 5) {
                        throw ioexception;
                    }
                    f_78191_.warn("Failed to delete {}", (Object)this.f_78271_, (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            File file2;
            this.m_78313_();
            File file1 = new File(LevelStorageSource.this.f_78194_.toFile(), this.f_78272_);
            if (file1.exists() && (file2 = new File(file1, "level.dat")).exists()) {
                CompoundTag compoundtag = NbtIo.m_128937_(file2);
                CompoundTag compoundtag1 = compoundtag.m_128469_(LevelStorageSource.f_202311_);
                compoundtag1.m_128359_("LevelName", p_78298_);
                NbtIo.m_128944_(compoundtag, file2);
            }
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String s = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path path = LevelStorageSource.this.m_78262_();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtil.m_133730_((Path)path, (String)s, (String)".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_78271_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s1 = path2.resolve(LevelStorageAccess.this.f_78271_.relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s1);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }
    }
}

